DROP PROCEDURE [hips].[HealthProviderOrganisationPatientInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 18 December 2012
-- Description:   Inserts a new record into the HealthProviderOrganisationPatient Table
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderOrganisationPatientInsert] 
(
	  @HealthProviderOrganisationId INT
	, @PatientMasterId INT
	, @PcehrAdvertised BIT = NULL
	, @AccessCodeRequiredId INT
	, @PcehrDisclosed BIT
	, @UserModified VARCHAR(256)
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int

    SET @intErrorCode = 0

    INSERT
     INTO [hips].[HealthProviderOrganisationPatient]
         ( [HealthProviderOrganisationId]
		 , [PatientMasterId]
         , [PcehrAdvertised]
         , [AccessCodeRequiredId]
		 , [PcehrDisclosed]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         )
    VALUES
         ( @HealthProviderOrganisationId
		 , @PatientMasterId
         , @PcehrAdvertised
         , @AccessCodeRequiredId
		 , @PcehrDisclosed
         , GETDATE()
         , @UserModified
         , GETDATE()
         , @UserModified
         )

    SELECT @intErrorCode = @@ERROR 
    IF @intErrorCode = 0
    BEGIN
        SELECT [HealthProviderOrganisationId]
			 , [PatientMasterId]
             , [PcehrAdvertised]
             , [AccessCodeRequiredId]
			 , [PcehrDisclosed]
             , [DateCreated]
             , [UserCreated]
             , [DateModified]
             , [UserModified]
         FROM [hips].[HealthProviderOrganisationPatient]
         WHERE [PatientMasterId] = @PatientMasterId
		 AND   [HealthProviderOrganisationId] = @HealthProviderOrganisationId
    END

    RETURN(@intErrorCode)
END
GO

